/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.base;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_12075;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animation.state.BoneSnapshot;
import software.bernie.geckolib.cache.model.BakedGeoModel;
import software.bernie.geckolib.cache.model.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.dataticket.DataTicket;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.object.DeferredCache;
import software.bernie.geckolib.renderer.base.BoneSnapshots;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.base.PerBoneRender;

public class RenderPassInfo<R extends GeoRenderState> {
    protected final GeoRenderer<?, ?, R> renderer;
    protected final R renderState;
    protected final class_4587 poseStack;
    protected final BakedGeoModel model;
    protected final class_12075 cameraState;
    protected final boolean willRender;
    protected final Matrix4f objectRenderPose;
    protected final Matrix4f modelRenderPose;
    protected final DeferredCache<List<BoneUpdater<R>>, BoneSnapshot[]> boneUpdates = new DeferredCache<List, BoneSnapshot[]>((List)new ObjectArrayList(), this::compileBoneUpdates);
    protected final Map<GeoBone, List<PerBoneRender<R>>> boneRenderTasks = new Reference2ObjectArrayMap();
    protected final Map<GeoBone, List<BonePositionListener>> bonePositionListeners = new Reference2ObjectArrayMap();

    protected RenderPassInfo(GeoRenderer<?, ?, R> renderer, R renderState, class_4587 poseStack, BakedGeoModel model, class_12075 cameraState, boolean willRender) {
        this.renderer = renderer;
        this.renderState = renderState;
        this.poseStack = poseStack;
        this.model = model;
        this.cameraState = cameraState;
        this.willRender = willRender;
        this.objectRenderPose = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        this.modelRenderPose = new Matrix4f();
    }

    public GeoRenderer<?, ?, R> renderer() {
        return this.renderer;
    }

    public R renderState() {
        return this.renderState;
    }

    public class_4587 poseStack() {
        return this.poseStack;
    }

    public BakedGeoModel model() {
        return this.model;
    }

    public class_12075 cameraState() {
        return this.cameraState;
    }

    public int packedLight() {
        return this.renderState.getPackedLight();
    }

    public int packedOverlay() {
        return this.renderState.getOrDefaultGeckolibData(DataTickets.PACKED_OVERLAY, class_4608.field_21444);
    }

    public int renderColor() {
        return this.renderState.getOrDefaultGeckolibData(DataTickets.RENDER_COLOR, -1);
    }

    public boolean willRender() {
        return this.willRender;
    }

    public <D> @Nullable D getGeckolibData(DataTicket<D> dataTicket) {
        return this.renderState().getGeckolibData(dataTicket);
    }

    public <D> D getOrDefaultGeckolibData(DataTicket<D> dataTicket, D fallback) {
        return this.renderState().getOrDefaultGeckolibData(dataTicket, fallback);
    }

    public Matrix4f getPreRenderMatrixState() {
        return this.objectRenderPose;
    }

    public Matrix4f getModelRenderMatrixState() {
        if ((this.modelRenderPose.properties() & 4) != 0) {
            throw new IllegalStateException("Attempting to access model render matrix state before it has been set");
        }
        return this.modelRenderPose;
    }

    public void addPerBoneRender(GeoBone bone, PerBoneRender<R> render) {
        this.boneRenderTasks.computeIfAbsent(bone, key -> new ObjectArrayList()).add(render);
    }

    public void addBoneUpdater(BoneUpdater<R> updater) {
        try {
            this.boneUpdates.getInput().add(updater);
        }
        catch (IllegalStateException ex) {
            GeckoLibConstants.LOGGER.error("BoneUpdater added after render pass submission", (Throwable)ex);
        }
    }

    public void addBonePositionListener(String boneName, BonePositionListener listener) {
        this.model.getBone(boneName).ifPresent(bone -> this.addBonePositionListener((GeoBone)bone, listener));
    }

    public void addBonePositionListener(GeoBone bone, BonePositionListener listener) {
        this.bonePositionListeners.computeIfAbsent(bone, key -> new ObjectArrayList()).add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderPosed(Runnable renderTask) {
        int i;
        BoneSnapshot[] updates = this.boneUpdates.compute();
        for (i = 0; i < updates.length; ++i) {
            updates[i].apply();
        }
        if (!this.bonePositionListeners.isEmpty()) {
            for (Map.Entry<GeoBone, List<BonePositionListener>> boneListeners : this.bonePositionListeners.entrySet()) {
                boneListeners.getKey().positionListeners = boneListeners.getValue().toArray(new BonePositionListener[0]);
            }
        }
        try {
            renderTask.run();
        }
        catch (Exception ex) {
            try {
                GeckoLibConstants.LOGGER.error("Error while rendering GeckoLib model", (Throwable)ex);
            }
            catch (Throwable throwable) {
                for (int i2 = 0; i2 < updates.length; ++i2) {
                    updates[i2].cleanup();
                }
                if (!this.bonePositionListeners.isEmpty()) {
                    for (GeoBone bone : this.bonePositionListeners.keySet()) {
                        bone.positionListeners = null;
                    }
                }
                throw throwable;
            }
            for (int i3 = 0; i3 < updates.length; ++i3) {
                updates[i3].cleanup();
            }
            if (!this.bonePositionListeners.isEmpty()) {
                for (GeoBone bone : this.bonePositionListeners.keySet()) {
                    bone.positionListeners = null;
                }
            }
        }
        for (i = 0; i < updates.length; ++i) {
            updates[i].cleanup();
        }
        if (!this.bonePositionListeners.isEmpty()) {
            for (GeoBone bone : this.bonePositionListeners.keySet()) {
                bone.positionListeners = null;
            }
        }
    }

    @ApiStatus.Internal
    public static <R extends GeoRenderState> RenderPassInfo<R> create(GeoRenderer<?, ?, R> renderer, R renderState, class_4587 poseStack, class_12075 cameraState, boolean willRender) {
        GeoModel geoModel = renderer.getGeoModel();
        BakedGeoModel model = geoModel.getBakedModel(geoModel.getModelResource(renderState));
        RenderPassInfo renderPassInfo = new RenderPassInfo(renderer, renderState, poseStack, model, cameraState, willRender);
        renderPassInfo.addBoneUpdater(renderer::applyAnimationControllers);
        renderPassInfo.addBoneUpdater(renderer::adjustModelBonesForRender);
        return renderPassInfo;
    }

    @ApiStatus.Internal
    protected BoneSnapshot[] compileBoneUpdates(List<BoneUpdater<R>> boneUpdaters) {
        ObjectArrayList snapshots = new ObjectArrayList(boneUpdaters.size());
        for (BoneUpdater<R> updater : boneUpdaters) {
            updater.run(this, arg_0 -> this.lambda$compileBoneUpdates$4((List)snapshots, arg_0));
        }
        BoneSnapshot[] array = snapshots.toArray(new BoneSnapshot[0]);
        for (int i = 0; i < array.length; ++i) {
            array[i].cleanup();
        }
        return array;
    }

    @ApiStatus.Internal
    public Map<GeoBone, List<PerBoneRender<R>>> getBoneRenderTasks() {
        return this.boneRenderTasks;
    }

    @ApiStatus.Internal
    public void captureModelRenderPose() {
        this.modelRenderPose.set((Matrix4fc)this.poseStack.method_23760().method_23761());
    }

    private /* synthetic */ Optional lambda$compileBoneUpdates$4(List snapshots, String boneName) {
        return this.model.getBone(boneName).map(bone -> {
            if (bone.frameSnapshot == null) {
                bone.frameSnapshot = BoneSnapshot.create(bone);
                snapshots.add(bone.frameSnapshot);
            }
            return bone.frameSnapshot;
        });
    }

    @FunctionalInterface
    public static interface BonePositionListener {
        public void accept(@Nullable class_243 var1, @Nullable class_243 var2, @Nullable class_243 var3);
    }

    @FunctionalInterface
    public static interface BoneUpdater<R extends GeoRenderState> {
        public void run(RenderPassInfo<R> var1, BoneSnapshots var2);
    }
}

